// DEMODlg.cpp : implementation file
//

#include "stdafx.h"
#include "DEMO.h"
#include "DEMODlg.h"
#include "CtrlCard.h"
#include "BaseParaSet.h"
#include "IOTest.h"
#include "SYSPARAM.h"

#include "adt8840.h"
#include <winsock.h>
#include <afxsock.h>
#include <afxcmn.h>



CCtrlCard	g_CtrlCard;
char	hand_mov=0;
extern  int devnum;
extern SYSPARA syspara;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
//int static line_count=0;//G Command lines
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDEMODlg dialog

CDEMODlg::CDEMODlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDEMODlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDEMODlg)
	m_nAddA = 0;
	m_nAddX = 0;
	m_nAddY = 0;
	m_nAddZ = 0;
	m_bA = FALSE;
	m_bX = FALSE;
	m_bY = FALSE;
	m_bZ = FALSE;
	m_nPulseA = 0;
	m_nPulseX = 0;
	m_nPulseY = 0;
	m_nPulseZ = 0;
	m_nSpeedA = 0;
	m_nSpeedX = 0;
	m_nSpeedY = 0;
	m_nSpeedZ = 0;
	m_nStartvA = 0;
	m_nStartvX = 0;
	m_nStartvY = 0;
	m_nStartvZ = 0;
	m_nFSpdMode = 0;
	m_nPulseUnitA = 0;
	m_nPulseUnitX = 0;
	m_nPulseUnitY = 0;
	m_nPulseUnitZ = 0;
	m_buff = TRUE;
	m_bUartShow = FALSE;
	m_PAUSE = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDEMODlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDEMODlg)
	DDX_Control(pDX, IDC_RTAIL, m_rtrail);
	DDX_Control(pDX, IDC_STATIC_TITLE, m_title);
	DDX_Text(pDX, IDC_ADD_W, m_nAddA);
	DDX_Text(pDX, IDC_ADD_X, m_nAddX);
	DDX_Text(pDX, IDC_ADD_Y, m_nAddY);
	DDX_Text(pDX, IDC_ADD_Z, m_nAddZ);
	DDX_Check(pDX, IDC_CHECK_W, m_bA);
	DDX_Check(pDX, IDC_CHECK_X, m_bX);
	DDX_Check(pDX, IDC_CHECK_Y, m_bY);
	DDX_Check(pDX, IDC_CHECK_Z, m_bZ);
	DDX_Text(pDX, IDC_PULSE_W, m_nPulseA);
	DDX_Text(pDX, IDC_PULSE_X, m_nPulseX);
	DDX_Text(pDX, IDC_PULSE_Y, m_nPulseY);
	DDX_Text(pDX, IDC_PULSE_Z, m_nPulseZ);
	DDX_Text(pDX, IDC_SPEED_W, m_nSpeedA);
	DDX_Text(pDX, IDC_SPEED_X, m_nSpeedX);
	DDX_Text(pDX, IDC_SPEED_Y, m_nSpeedY);
	DDX_Text(pDX, IDC_SPEED_Z, m_nSpeedZ);
	DDX_Text(pDX, IDC_STARTV_W, m_nStartvA);
	DDX_Text(pDX, IDC_STARTV_X, m_nStartvX);
	DDX_Text(pDX, IDC_STARTV_Y, m_nStartvY);
	DDX_Text(pDX, IDC_STARTV_Z, m_nStartvZ);
	DDX_Radio(pDX, IDC_FS_SPEEDMODE0, m_nFSpdMode);
	DDX_Text(pDX, IDC_PULSE_UNIT_A, m_nPulseUnitA);
	DDX_Text(pDX, IDC_PULSE_UNIT_X, m_nPulseUnitX);
	DDX_Text(pDX, IDC_PULSE_UNIT_Y, m_nPulseUnitY);
	DDX_Text(pDX, IDC_PULSE_UNIT_Z, m_nPulseUnitZ);
	DDX_Check(pDX, IDC_CHECK_BUFF_MODE, m_buff);
	DDX_Check(pDX, IDC_CHECK_UART, m_bUartShow);
	DDX_Check(pDX, IDC_CHECK_PAUSERESUM, m_PAUSE);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDEMODlg, CDialog)
	//{{AFX_MSG_MAP(CDEMODlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_PMOVE, OnButtonPmove)
	ON_BN_CLICKED(IDC_BUTTON_INPMOVE, OnButtonInpmove)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_IOTEST, OnButtonIotest)
	ON_BN_CLICKED(IDC_BUTTON_BASEPARA, OnButtonBasepara)
	ON_BN_CLICKED(IDC_BUTTON_CLEARPOS, OnButtonClearpos)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BTN_INTIAL_DEV, OnBtnIntialDev)
	ON_BN_CLICKED(IDC_BUTTON_CMOVE, OnButtonCmove)
	ON_BN_CLICKED(IDC_BTN_GFILE_WORK, OnBtnGfileWork)
	ON_BN_CLICKED(IDC_BTN_WORKSTOP, OnBtnWorkstop)
	ON_BN_CLICKED(IDC_BTN_LOAD_GFILE, OnBtnLoadGfile)
	ON_BN_CLICKED(IDC_CHECK_UART, OnCheckUart)
	ON_BN_CLICKED(IDC_BTN_SYSPARAM, OnBtnSysparam)
	ON_BN_CLICKED(IDC_BTN_REMOVE, OnBtnRemove)
	ON_BN_CLICKED(IDC_BUTTON_FIFO, OnButtonFifo)
	ON_BN_CLICKED(IDC_BTN_OPEN_GFILE, OnBtnOpenGfile)
	ON_BN_CLICKED(IDC_BTN_HOME, OnBtnHome)
	ON_BN_CLICKED(IDC_CHECK_BUFF_MODE, OnCheckBuffMode)
	ON_BN_CLICKED(IDC_FS_SPEEDMODE0, OnFsSpeedmode0)
	ON_BN_CLICKED(IDC_FS_SPEEDMODE1, OnFsSpeedmode1)
	ON_BN_CLICKED(IDC_BTN_ARC, OnBtnArc)
	ON_BN_CLICKED(IDC_BTN_SINGLE_GCODE, OnBtnSingleGcode)
	ON_BN_CLICKED(IDC_BTN_MULTI_GCODE, OnBtnMultiGcode)
	ON_BN_CLICKED(IDC_BUTTON_FRESHEN, OnButtonFreshen)
	ON_BN_CLICKED(IDC_BUTTON_RUNRAM, OnButtonRunram)
	ON_BN_CLICKED(IDC_BUTTON_DOWNLOAD, OnButtonDownload)
	ON_BN_CLICKED(IDC_CHECK_PAUSERESUM, OnCheckPauseresum)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_BN_CLICKED(IDC_CLOSE_CONN, OnCloseConn)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDEMODlg message handlers

BOOL CDEMODlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CButton *btn;
	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	OnCheckBuffMode();
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	// TODO: Add extra initialization here

//*************Set Title**************	
	CWnd   *wnd;   	
	pFont.CreateFont(0,0,0,0,900,FALSE,FALSE,0,ANSI_CHARSET,OUT_STROKE_PRECIS, CLIP_STROKE_PRECIS,
		DEFAULT_QUALITY,VARIABLE_PITCH|FF_SWISS,_T(""));   
    wnd=(CWnd*)GetDlgItem(IDC_STATIC_TITLE);
	wnd->SetFont(&pFont); 

 //   SetDlgItemText(IDC_EDIT_OPPIP,"192.168.0.122");//IP address of the designated control card

	((CIPAddressCtrl*)GetDlgItem(IDC_IPADDRS))->SetAddress(192,168,0,123);
		
	SetDlgItemText(IDC_EDIT_MAC,"00-AB-CD-00-01-23");//Specified card address

    SetDlgItemText(IDC_EDIT_FSTYLE,"r");//Set file read-write mode

	SetDlgItemText(IDC_OPERATE_INFO,"First implementation of the initialization");
		 
	DeviceAddr_init();// Device Interface address initialization		

//****************************************

//*******Set the default initial velocity 500	*********
	m_nStartvX = 500;
	m_nStartvY = 500;
	m_nStartvZ = 500;
	m_nStartvA = 500;
//*********Set the default drive speed 2000********
	m_nSpeedX  = 2000; 
	m_nSpeedY  = 2000; 
	m_nSpeedZ  = 2000; 
	m_nSpeedA  = 2000; 
//*********Set the default acceleration 50**********
	m_nAddX    = 50;
	m_nAddY    = 50;
	m_nAddZ    = 50;
	m_nAddA    = 50;

//********Set the default target location for10000******
	m_nPulseX  = 10000;
	m_nPulseY  = 10000;
	m_nPulseZ  = 10000;
	m_nPulseA  = 10000;

//********Set the default pulse equivalent to 160 (ie: control card issued 160 pulses corresponding mechanical movement of 1 mm)******
	m_nPulseUnitX  = 160;
	m_nPulseUnitY  = 160;
	m_nPulseUnitZ  = 160;
	m_nPulseUnitA  = 160;

//********Set the default analog processing path******
    m_bDrawTrail=FALSE;

//********Set the default file does not open G******
	m_bOpenGfile=FALSE;


//********Settings button initial state********
	btn=(CButton*)GetDlgItem(IDC_BUTTON_PMOVE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_CMOVE);		
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_INPMOVE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_CLEARPOS);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_BASEPARA);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_IOTEST);		
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_FIFO);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_ARC);
	btn->EnableWindow(FALSE);	
	btn=(CButton*)GetDlgItem(IDC_BUTTON_FRESHEN);
	btn->EnableWindow(FALSE);	
	btn=(CButton*)GetDlgItem(IDC_CHECK_PAUSERESUM);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_CLOSE_CONN);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_FS_SPEEDMODE0);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_FS_SPEEDMODE1);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_CHECK_UART);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_CHECK_BUFF_MODE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_UP);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_DOWN);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_LEFT);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_RIGHT);
	btn->EnableWindow(FALSE);

	btn=(CButton*)GetDlgItem(IDC_BTN_SYSPARAM);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_LOAD_GFILE);
	btn->EnableWindow(FALSE);			
	btn=(CButton*)GetDlgItem(IDC_BTN_SINGLE_GCODE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_MULTI_GCODE);
	btn->EnableWindow(FALSE);						
	btn=(CButton*)GetDlgItem(IDC_BTN_GFILE_WORK);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_HOME);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_REMOVE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_OPEN_GFILE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_WORKSTOP);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_STOP);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_DOWNLOAD);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_RUNRAM);
	btn->EnableWindow(FALSE);

	UpdateData(FALSE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDEMODlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDEMODlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDEMODlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/*********************************
           Linkage button action
*******************************/
void CDEMODlg::OnButtonPmove() 
{
	char sel_combin,i,n;
	int	 axis[4]={0};
	UpdateData(TRUE);
	m_bDrawTrail=FALSE;
	long Startv[]={m_nStartvX,m_nStartvY,m_nStartvZ,m_nStartvA};  //Initial velocity

	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedA};       //Driving speed
	
	long Add[]  ={m_nAddX,m_nAddY,m_nAddZ,m_nAddA};               //Acceleration
    
	long Pulse[]={m_nPulseX,m_nPulseY,m_nPulseZ,m_nPulseA};          //Axis of the drive pulses


	int PulseUnit[]={m_nPulseUnitX,m_nPulseUnitY,m_nPulseUnitZ,m_nPulseUnitA};          //Axis of the drive pulses

	sel_combin=m_bX | (m_bY<<1) | (m_bZ<<2)|(m_bA<<3);

	for(i=0,n=0;i<4;i++)
	{
		if(sel_combin & (1<<i))
		{
			axis[n]=i;
			n++;
		}
	}
	switch(n)
	{
		case 1:
		{
			g_CtrlCard.Setup_Speed(axis[0]+1, Startv[axis[0]], Speed[axis[0]], Add[axis[0]]);//Set X-axis speed
			adt8840a_pmove(devnum,axis[0]+1,Pulse[axis[n]]);
			break;
		}
		case 2:
		{
			g_CtrlCard.Setup_Speed(axis[0]+1, Startv[axis[0]], Speed[axis[0]], Add[axis[0]]);//The first axis of the speed set
			g_CtrlCard.Setup_Speed(axis[1]+1, Startv[axis[1]], Speed[axis[1]], Add[axis[1]]);//The second axis of the speed set
			adt8840a_pmove2(devnum,axis[0]+1,axis[1]+1,Pulse[axis[0]],Pulse[axis[1]]);
			break;
		}
		case 3:
		{
			g_CtrlCard.Setup_Speed(axis[0]+1, Startv[axis[0]], Speed[axis[0]], Add[axis[0]]);//The first axis of the speed set
			g_CtrlCard.Setup_Speed(axis[1]+1, Startv[axis[1]], Speed[axis[1]], Add[axis[1]]);//The second axis of the speed set
			g_CtrlCard.Setup_Speed(axis[2]+1, Startv[axis[2]], Speed[axis[2]], Add[axis[2]]);//The third axis of the speed set
			adt8840a_pmove3(devnum,axis[0]+1,axis[1]+1,axis[2]+1,Pulse[axis[0]],Pulse[axis[1]],Pulse[axis[2]]);
			break;
		}
		case 4:
		{
			g_CtrlCard.Setup_Speed(axis[0]+1, Startv[axis[0]], Speed[axis[0]], Add[axis[0]]);//The first axis of the speed set
			g_CtrlCard.Setup_Speed(axis[1]+1, Startv[axis[1]], Speed[axis[1]], Add[axis[1]]);//The second axis of the speed set
			g_CtrlCard.Setup_Speed(axis[2]+1, Startv[axis[2]], Speed[axis[2]], Add[axis[2]]);//The third axis of the speed set
			g_CtrlCard.Setup_Speed(axis[3]+1, Startv[axis[3]], Speed[axis[3]], Add[axis[3]]);//The fouth axis of the speed set
			adt8840a_pmove4(devnum,Pulse[axis[0]],Pulse[axis[1]],Pulse[axis[2]],Pulse[axis[3]]);
			break;
		}
		default:
			MessageBox("Please select the linkage shaft!", "Prompt");
			break;
	}

}


/*********************************
          Continuous movement of the button action 
*******************************/
void CDEMODlg::OnButtonCmove() 
{
	UpdateData(TRUE);
	m_bDrawTrail=FALSE;
	long Startv[]={m_nStartvX,m_nStartvY,m_nStartvZ,m_nStartvA};  //Initial velocity	
	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedA};       //Driving speed	
	long Add[]  ={m_nAddX,m_nAddY,m_nAddZ,m_nAddA};               //Acceleration	
	
	
	if(!m_bX&&!m_bY&&!m_bZ&&!m_bA)
	{
		AfxMessageBox("Select the drive shaft!");
		return ;
	}		
	/**************************************************/
	//Continuous movement is under the direction of movement, so to judge it with the // 
// Pmove difference is that it is based on the number of pulses issued to set the direction / /

	//                                                //
	/**************************************************/
	if(m_bX)   
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0]);					
	if(m_bY)
		g_CtrlCard.Setup_Speed(2, Startv[1], Speed[1], Add[1]);
	if(m_bZ)
		g_CtrlCard.Setup_Speed(3, Startv[2], Speed[2], Add[2]);
	if(m_bA)
		g_CtrlCard.Setup_Speed(4, Startv[3], Speed[3], Add[3]);

	/**************************************************/	
	if(m_bX)   
		g_CtrlCard.Axis_Cmove(1,m_nPulseX>0?0:1);		
	if(m_bY)
		g_CtrlCard.Axis_Cmove(2,m_nPulseY>0?0:1);		
	if(m_bZ)
		g_CtrlCard.Axis_Cmove(3,m_nPulseZ>0?0:1);					
	if(m_bA)
		g_CtrlCard.Axis_Cmove(4,m_nPulseA>0?0:1);	
}

/*********************************
          Interpolation button action
*********************************/
void CDEMODlg::OnButtonInpmove() 
{
	char sel_combin,i,n;
	int	 axis[4]={0};
	UpdateData(TRUE);
	m_bDrawTrail=FALSE;
	long Startv[]={m_nStartvX,m_nStartvY,m_nStartvZ,m_nStartvA};  //Initial velocity

	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedA};       //Driving speed

	long Add[]  ={m_nAddX,m_nAddY,m_nAddZ,m_nAddA};               //Acceleration

    long Pulse[]={m_nPulseX,m_nPulseY,m_nPulseZ,m_nPulseA};          //Axis of the drive pulses

	sel_combin=m_bX | (m_bY<<1) | (m_bZ<<2)|(m_bA<<3);

	for(i=0,n=0;i<4;i++)
	{
		if(sel_combin & (1<<i))
		{
			axis[n]=i;
			n++;
		}
	}
	switch(n)
	{
		case 1:
		{
			MessageBox("Please choose United over two axes for interpolation!", "Prompt");
			break;
		}
		case 2:
		{
			g_CtrlCard.Setup_Speed(axis[0]+1, Startv[axis[0]], Speed[axis[0]], Add[axis[0]]);//The first axis of the speed set
			adt8840a_inp_move2(devnum,axis[0]+1,axis[1]+1,Pulse[axis[0]],Pulse[axis[1]]);
			break;
		}
		case 3:
		{
			g_CtrlCard.Setup_Speed(axis[0]+1, Startv[axis[0]], Speed[axis[0]], Add[axis[0]]);//The first axis of the speed set
			adt8840a_inp_move3(devnum,axis[0]+1,axis[1]+1,axis[2]+1,Pulse[axis[0]],Pulse[axis[1]],Pulse[axis[2]]);
			break;
		}
		case 4:
		{
			g_CtrlCard.Setup_Speed(axis[0]+1, Startv[axis[0]], Speed[axis[0]], Add[axis[0]]);//The first axis of the speed set
			adt8840a_inp_move4(devnum,Pulse[axis[0]],Pulse[axis[1]],Pulse[axis[2]],Pulse[axis[3]]);
			break;
		}
		default:
			MessageBox("Please select the linkage shaft!", "Prompt");
			break;
	}
}
/******************************
       Stop button action
*******************************/
void CDEMODlg::OnButtonStop() 
{
	char sel_combin,i;

	UpdateData(TRUE);
	if(m_buff)
	{
		adt8840a_clear_buff_depth(devnum); //Empty the cache
		for(i=0;i<4;i++)
			g_CtrlCard.StopRun(i+1,1);//Deceleration stop
		KillTimer(GCODETIMER);
		m_nLineCount=0;
	}else
	{
		sel_combin=m_bX | (m_bY<<1) | (m_bZ<<2)|(m_bA<<3);
		for(i=0;i<4;i++)
		{
			if(sel_combin & (1<<i))
			{
				g_CtrlCard.StopRun(i+1,1);//Deceleration stop
			}
		}
	}
}

//******************** Real-time access to state ************************* // 
// Get the logical position, actual position, speed and drive status // 
// read positive and negative limit, stop0 //
//*********************************************************//
static char show_ref=0;
void CDEMODlg::OnTimer(UINT nIDEvent) 
{
	long log[4],act[4],spd[4];
	UINT nID1[]={IDC_POS_LOGX,IDC_POS_LOGY,IDC_POS_LOGZ,IDC_POS_LOGW};
	UINT nID2[]={IDC_POS_ACTX,IDC_POS_ACTY,IDC_POS_ACTZ,IDC_POS_ACTW};
	UINT nID3[]={IDC_RUNSPEED_X,IDC_RUNSPEED_Y,IDC_RUNSPEED_Z,IDC_RUNSPEED_W};
	CStatic *lbl;
	CString str;
	char strGcode[128],gcode[64];

	int i=1,tmp;
	CButton *btn;	    
//****************** Signal detection *****************
// X axis STOP0 0 Y axis STOP0 1 
// Z-axis STOP0 2 A-axis STOP0 3 
// x-axis is limit -4 x-axis negative limit -5 
// Y axis is the negative limit -6 Y-axis limit -7 
// Z axis is limit -8 Z-axis negative limit -9 
// A limit -10 A shaft axis is negative limit -11 
// X axis STOP1 38 Y-axis STOP1 39 
// encoder Z-phase input for STOP1 
// Z axis STOP1 40 A-axis STOP1 41 
//*******************************************

	UINT nIDIN1[]={   
	    IDC_STOP0_X,IDC_STOP0_Y,              //X, Y origin      
	    IDC_STOP0_Z,IDC_STOP0_W,              //Z, A origin
        IDC_LIMIT_X,IDC_LIMIT_X2,             //X-axis positive and negative limit
		IDC_LIMIT_Y,IDC_LIMIT_Y2,             //Y-axis positive and negative limit
		IDC_LIMIT_Z,IDC_LIMIT_Z2,             //Z-axis positive and negative limit
		IDC_LIMIT_W,IDC_LIMIT_W2,             //A-axis positive and negative limit
        IDC_STOP1_X,IDC_STOP1_Y,              //XY-axis STOP1
		IDC_STOP1_Z,IDC_STOP1_W };            //ZA-axis STOP1
		
	int io[]={0,1,2,3,4,5,6,7,8,9,10,11,38,39,40,41};
	int value;
	
	int line,length,clen,nIndex,idle,g_status,lock_stop;

	switch(nIDEvent) 
	{
	case MAINTIMER :		
		g_CtrlCard.Get_AxisInfo(devnum, log, act, spd);//Logical location for all axes, the actual position and speed
		for (i=1; i<MAXAXIS+1; i++)
		{
			//********Show logical location********//
				lbl=(CStatic*)GetDlgItem(nID1[i-1]);
				str.Format("%ld",log[i-1]);
				lbl->SetWindowText(str);                      
				//********Show the actual location********//
				lbl=(CStatic*)GetDlgItem(nID2[i-1]);
				str.Format("%ld",act[i-1]);
				lbl->SetWindowText(str);
				//********Display speed********//
				lbl=(CStatic*)GetDlgItem(nID3[i-1]);
				//Without magnification settings, get the value of the actual speed =
				str.Format("%ld",spd[i-1]);
				lbl->SetWindowText(str);
				//******Get Driving States******//
				//g_CtrlCard.Get_Status(i,status[i-1],0);
		}
		adt8840a_read_8bit(devnum,0,&value);
		tmp=value;
		adt8840a_read_8bit(devnum,8,&value);
		value =value<<8 | tmp;
		for (i=0; i<12; i++)
		{//0-11
			//g_CtrlCard.Read_Input(io[i],value);//Read signal               
			btn=(CButton*)GetDlgItem(nIDIN1[i]);		
			btn->SetCheck((value & (1<<i))==0?1:0);
		}	
		adt8840a_read_8bit(devnum,38,&value);
		for (i=12; i<16; i++)
		{//38-41
			//g_CtrlCard.Read_Input(io[i],value);//Read signal               
			btn=(CButton*)GetDlgItem(nIDIN1[i]);		
			btn->SetCheck((value & (1<<(i-12)))==0?1:0);
		}

		//Button Control

		adt8840a_get_sys_status( devnum,&idle,&g_status,&lock_stop);
		if(idle==0 )
		{
			if(show_ref==0)
			{
				//Drive to complete
				show_ref=1;
				btn=(CButton*)GetDlgItem(IDC_BUTTON_PMOVE);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BUTTON_CMOVE);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BUTTON_INPMOVE);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BUTTON_CLEARPOS);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BUTTON_BASEPARA);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BUTTON_IOTEST);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BUTTON_FIFO);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BTN_ARC);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BUTTON_FRESHEN);
				btn->EnableWindow(TRUE);	
				btn=(CButton*)GetDlgItem(IDC_CHECK_PAUSERESUM);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_FS_SPEEDMODE0);
				btn->EnableWindow(TRUE);	
				btn=(CButton*)GetDlgItem(IDC_FS_SPEEDMODE1);
				btn->EnableWindow(TRUE);	
				btn=(CButton*)GetDlgItem(IDC_CHECK_UART);
				btn->EnableWindow(TRUE);	
				btn=(CButton*)GetDlgItem(IDC_CHECK_BUFF_MODE);
				btn->EnableWindow(TRUE);	
				btn=(CButton*)GetDlgItem(IDC_BUTTON_UP);
				btn->EnableWindow(TRUE);	
				btn=(CButton*)GetDlgItem(IDC_BUTTON_DOWN);
				btn->EnableWindow(TRUE);	
				btn=(CButton*)GetDlgItem(IDC_BUTTON_LEFT);
				btn->EnableWindow(TRUE);	
				btn=(CButton*)GetDlgItem(IDC_BUTTON_RIGHT);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BUTTON_DOWNLOAD);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BUTTON_RUNRAM);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BUTTON_STOP);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BTN_SYSPARAM);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BTN_LOAD_GFILE);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BTN_SINGLE_GCODE);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BTN_MULTI_GCODE);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BTN_GFILE_WORK);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BTN_HOME);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BTN_REMOVE);
				btn->EnableWindow(TRUE);			
				btn=(CButton*)GetDlgItem(IDC_BTN_OPEN_GFILE);
				btn->EnableWindow(TRUE);
				btn=(CButton*)GetDlgItem(IDC_BTN_WORKSTOP);
				btn->EnableWindow(TRUE);
			}
		}
		else
		{//The ongoing drive
			btn=(CButton*)GetDlgItem(IDC_CHECK_PAUSERESUM);
			btn->EnableWindow(TRUE);
			if(show_ref==1)
			{
				show_ref=0;
				if(g_status==1)
				{
					btn=(CButton*)GetDlgItem(IDC_BUTTON_PMOVE);
					btn->EnableWindow(FALSE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_CMOVE);
					btn->EnableWindow(FALSE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_INPMOVE);
					btn->EnableWindow(FALSE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_FIFO);
					btn->EnableWindow(FALSE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_CLEARPOS);
					btn->EnableWindow(FALSE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_BASEPARA);
					btn->EnableWindow(FALSE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_IOTEST);		
					btn->EnableWindow(FALSE);
					btn=(CButton*)GetDlgItem(IDC_BTN_SYSPARAM);
					btn->EnableWindow(FALSE);
					btn=(CButton*)GetDlgItem(IDC_BTN_REMOVE);
					btn->EnableWindow(FALSE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_STOP);
					btn->EnableWindow(FALSE);
					btn=(CButton*)GetDlgItem(IDC_BTN_ARC);
					btn->EnableWindow(FALSE);
					m_bDrawTrail=TRUE;
				}else
				{
					btn=(CButton*)GetDlgItem(IDC_BUTTON_PMOVE);
					btn->EnableWindow(TRUE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_CMOVE);		
					btn->EnableWindow(TRUE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_INPMOVE);
					btn->EnableWindow(TRUE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_CLEARPOS);
					btn->EnableWindow(TRUE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_BASEPARA);
					btn->EnableWindow(TRUE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_IOTEST);		
					btn->EnableWindow(TRUE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_FIFO);
					btn->EnableWindow(TRUE);
					btn=(CButton*)GetDlgItem(IDC_BTN_SYSPARAM);
					btn->EnableWindow(TRUE);
					btn=(CButton*)GetDlgItem(IDC_BTN_REMOVE);
					btn->EnableWindow(TRUE);
					btn=(CButton*)GetDlgItem(IDC_BUTTON_STOP);
					btn->EnableWindow(TRUE);

				}
				btn=(CButton*)GetDlgItem(IDC_FS_SPEEDMODE0);
				btn->EnableWindow(FALSE);	
				btn=(CButton*)GetDlgItem(IDC_FS_SPEEDMODE1);
				btn->EnableWindow(FALSE);	
				btn=(CButton*)GetDlgItem(IDC_CHECK_UART);
				btn->EnableWindow(FALSE);	
				btn=(CButton*)GetDlgItem(IDC_CHECK_BUFF_MODE);
				btn->EnableWindow(FALSE);	
				btn=(CButton*)GetDlgItem(IDC_BUTTON_DOWNLOAD);
				btn->EnableWindow(FALSE);
				btn=(CButton*)GetDlgItem(IDC_BUTTON_RUNRAM);
				btn->EnableWindow(FALSE);
				btn=(CButton*)GetDlgItem(IDC_BTN_LOAD_GFILE);
				btn->EnableWindow(FALSE);			
				btn=(CButton*)GetDlgItem(IDC_BTN_SINGLE_GCODE);
				btn->EnableWindow(FALSE);
				btn=(CButton*)GetDlgItem(IDC_BTN_MULTI_GCODE);
				btn->EnableWindow(FALSE);						
				btn=(CButton*)GetDlgItem(IDC_BTN_GFILE_WORK);
				btn->EnableWindow(FALSE);
				btn=(CButton*)GetDlgItem(IDC_BTN_HOME);
				btn->EnableWindow(FALSE);	
				btn=(CButton*)GetDlgItem(IDC_BTN_OPEN_GFILE);
				btn->EnableWindow(FALSE);
				if(hand_mov==0)
				{
					btn=(CButton*)GetDlgItem(IDC_BUTTON_UP);
					btn->EnableWindow(FALSE);	
					btn=(CButton*)GetDlgItem(IDC_BUTTON_DOWN);
					btn->EnableWindow(FALSE);	
					btn=(CButton*)GetDlgItem(IDC_BUTTON_LEFT);
					btn->EnableWindow(FALSE);	
					btn=(CButton*)GetDlgItem(IDC_BUTTON_RIGHT);
					btn->EnableWindow(FALSE);
				}
			}else
			{
				if(show_ref==0)
				{
					if(g_status==0)
					{
						btn=(CButton*)GetDlgItem(IDC_BUTTON_PMOVE);
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BUTTON_CMOVE);		
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BUTTON_INPMOVE);
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BUTTON_CLEARPOS);
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BUTTON_BASEPARA);
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BUTTON_IOTEST);		
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BUTTON_FIFO);
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BTN_SYSPARAM);
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BTN_REMOVE);
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BUTTON_STOP);
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BTN_WORKSTOP);
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BUTTON_FRESHEN);
						btn->EnableWindow(TRUE);
						btn=(CButton*)GetDlgItem(IDC_BTN_ARC);
						btn->EnableWindow(TRUE);
					}
				}
			}
		}	
	     break;
	case TRACETIMER:
		//Analog processing path
		if(m_bDrawTrail)		
		{
			//Check control card has been received G instruction cache depth and instruction currently being executed G		
			adt8840a_get_gcode_depth(devnum,&m_ndepth,gcode);	
			SetDlgItemText(IDC_CURRENTGCODE,gcode);			
			CClientDC dc(this);
			CRect rc,rw;
			CPoint pt;
			GetDlgItem(IDC_RTAIL)->GetWindowRect(rc);
			lbl=(CStatic*)GetDlgItem(nID1[0]);			
			lbl->GetWindowText(str); 	
			pt.x=atol(str);		
			lbl=(CStatic*)GetDlgItem(nID1[1]);		
			lbl->GetWindowText(str); 
			pt.y=atol(str);		
			GetWindowRect(rw);
			dc.SetPixel((int)(pt.x*3.78/syspara.lPulseMm[0])+rc.left-rw.left+33,(int)(pt.y*3.78/syspara.lPulseMm[1])+rc.top-rw.top+25,RGB(255,0,0));	
		}
		break;
    case GCODETIMER:
		line=(((CEdit*)GetDlgItem(IDC_EDIT_SHOW_GFILE))->GetLineCount());	
		if(m_nLineCount<line)
		{//Until the very last line	
			nIndex = ((CEdit*)GetDlgItem(IDC_EDIT_SHOW_GFILE))->LineIndex(m_nLineCount);
			clen = ((CEdit*)GetDlgItem(IDC_EDIT_SHOW_GFILE))->LineLength(nIndex);
			if(nIndex==0 && clen==0)
			{
				KillTimer(GCODETIMER);
				AfxMessageBox("No data");
			}else
			{
				length=((CEdit*)GetDlgItem(IDC_EDIT_SHOW_GFILE))->GetLine(m_nLineCount,strGcode,clen);
				strGcode[length]=0;
				if(m_ndepth<128)
				{//128 less than the cache
					adt8840a_g_code(devnum,strGcode);
					m_nLineCount++;
				}
			}
		}
		else
		{//Write is completed, out of
			m_nLineCount=0;
			KillTimer(GCODETIMER);
		}
	    break;
	case BLOCKTIMER:
		{
			CString gdata;
			int len;
			GetDlgItemText(IDC_EDIT_SHOW_GFILE,gdata);
			len=gdata.GetLength()+1;
			if(len<2)
			{
				KillTimer(BLOCKTIMER);
				AfxMessageBox("No data");
			}
			else
			{
				if(m_nSendLen<len)
				{//Sent the length is less than length
					adt8840a_buff_block_status(devnum,&m_nDataStatus);
					if(m_nDataStatus==0)
					{//Cache block is in idle state
						if(len>=0x100000)
						{//Length greater than 1M
							if((len-m_nSendLen)>DATA_SECTION)
							{//The remaining length is greater than the limits of bulk download
								adt8840a_download_gcode(devnum,(char*)((int)gdata.GetBuffer(len)+m_nSendLen),DATA_SECTION);
								m_nSendLen +=DATA_SECTION;
							}
							else
							{
								adt8840a_download_gcode(devnum,(char*)((int)gdata.GetBuffer(len)+m_nSendLen),len-m_nSendLen);
								m_nSendLen =len;//Download Complete
							}
						}
						else
						{
							adt8840a_download_gcode(devnum,(char*)((int)gdata.GetBuffer(len)+m_nSendLen),len);
							m_nSendLen =len;
							adt8840a_ram_pre(devnum);
						}
					}
				}
			}
			break;
		}
	default:
		break;
	}

	CDialog::OnTimer(nIDEvent);
}

void CDEMODlg::OnButtonIotest() 
{
	this->KillTimer(MAINTIMER);
	CIOTest dlg;
	dlg.DoModal();
	SetTimer(MAINTIMER,30,NULL); 	
}

void CDEMODlg::OnButtonBasepara() 
{
	this->KillTimer(MAINTIMER);
	CBaseParaSet dlg;
	dlg.DoModal();
	SetTimer(MAINTIMER,30,NULL);	
}

void CDEMODlg::OnButtonClearpos() 
{
	for(int i=1; i<MAXAXIS+1; i++)
	{
		g_CtrlCard.Setup_Pos(i, 0, 0);    //Logical position is set to zero
		g_CtrlCard.Setup_Pos(i, 0, 1);    //Actual location is set to zero
	}	
}

void CDEMODlg::InitialDevice() 
{//Interface Initialization
	CString ID,ip_init,mac_str;
	int len,mode =0, err=0,temp;
	UINT sock=0;
	char str[32],ip_in[32],arp_in[32];
	CButton *btn;
    CIPAddressCtrl *dev_IP;	

    UpdateData(FALSE);
      //Connection state detection
     GetDlgItemText(IDC_IPADDRS,ip_init);
	 len=ip_init.GetLength()+1;
	 strncpy(ip_in, ip_init, len);
	 ip_in[len]=0;
		
	GetDlgItemText(IDC_EDIT_MAC,mac_str);
	len=mac_str.GetLength()+1;
	strncpy(arp_in, mac_str, len);
	arp_in[len]=0;
	
	temp=TCP_Conn(ip_in,arp_in,&err);

	sock=Get_sock( temp);
	if(sock !=0xffffffff )
	{
		devnum=temp;
		sprintf(str,"%d", devnum);
		ID=str;
		SetDlgItemText(IDC_EDIT_IDNUM,ID);
		SetDlgItemText(IDC_EDIT_LINKSTATUS,"Link OK");
		show_ref=0;
		//Card initialization parameters
		int result=	g_CtrlCard.Init_Board( devnum);
		if (result==1)
		{	
			AfxMessageBox("ADT8840 Initialization complete");
			SetDlgItemText(IDC_OPERATE_INFO,"Initialization complete");

			btn=(CButton*)GetDlgItem(IDC_BTN_INTIAL_DEV);			
			btn->EnableWindow(FALSE);
			dev_IP=(CIPAddressCtrl*)GetDlgItem(IDC_IPADDRS);
			dev_IP->EnableWindow(FALSE);
			GetDlgItem(IDC_EDIT_MAC)->EnableWindow(FALSE);

			SetTimer(MAINTIMER,30,NULL);  //Start main timer 
			OnCheckUart();
			OnCheckBuffMode();
			adt8840a_upload_sysfile(devnum,0,"",&syspara);	

			SetTimer(TRACETIMER,30,NULL);  //Start track timer 
			btn=(CButton*)GetDlgItem(IDC_CLOSE_CONN);
			btn->EnableWindow(TRUE);
		}
		else 			
		{
			AfxMessageBox("ADT8840 Initialization failed");	
		    SetDlgItemText(IDC_OPERATE_INFO,"Initialization failed");
		}
	}
	else
	{
		SetDlgItemText(IDC_EDIT_LINKSTATUS,"Connection Failure");
		switch(err)
		{
		case 0:
			break;
		case 1:
			SetDlgItemText(IDC_OPERATE_INFO,"Connection already exists");
			break;
		case 2:
			SetDlgItemText(IDC_OPERATE_INFO,"Exceed the maximum number of connections");
			break;
		case 3:
			SetDlgItemText(IDC_OPERATE_INFO,"Failed to create SOCKET");
			break;
		default:
			SetDlgItemText(IDC_OPERATE_INFO,"TCP Connection Failure");
			break;
		}
	}
}

void CDEMODlg::OnClose() 
{
	/*
	int i;
	for (i=0; i<21; i++)
	{
		adt8840a_write_bit(devnum, i, 0);
	}*/
	
	Close_netconn(devnum);
	Close_all();//Release resources	

	CDialog::OnClose();
}

void CDEMODlg::OnBtnIntialDev() 
{
	InitialDevice() ;
}

void CDEMODlg::OnBtnLoadGfile() 
{
    int result =adt8840a_download_gfile(devnum);
	if(!result)
		AfxMessageBox("G Code download success");
}

void CDEMODlg::OnBtnGfileWork() 
{  
	m_bDrawTrail=TRUE;
	adt8840a_run_gfile(devnum);
}

void CDEMODlg::OnBtnWorkstop() 
{
	adt8840a_stop_all(devnum);
	m_PAUSE=0;
	GetDlgItem(IDC_CHECK_PAUSERESUM)->SetWindowText("Suspension of processing");	
	UpdateData(FALSE);
	KillTimer(GCODETIMER);
	m_nLineCount=0;
}

void CDEMODlg::OnCheckUart() 
{
	UpdateData();
	if(m_bUartShow)
		Uart_show(devnum,2);
	else
		Uart_show(devnum,0);	
}

void CDEMODlg::OnBtnSysparam() 
{
	this->KillTimer(MAINTIMER);
	CSYSPARAM dlg;
	dlg.DoModal();	
	SetTimer(MAINTIMER,30,NULL);
}

void CDEMODlg::OnBtnRemove() 
{
	int result;
	result=	adt8840a_FS_Remove( devnum,"system.ini");
}

void CDEMODlg::OnButtonFifo() 
{ 
	char sel_combin,i,n;
	int	 axis[4]={0};
	UpdateData(TRUE);
	m_bDrawTrail=FALSE;
	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedA};       //Driving speed
    long Pulse[]={m_nPulseX,m_nPulseY,m_nPulseZ,m_nPulseA};          //Axis of the drive pulses

	sel_combin=m_bX | (m_bY<<1) | (m_bZ<<2)|(m_bA<<3);

	for(i=0,n=0;i<4;i++)
	{
		if(sel_combin & (1<<i))
		{
			axis[n]=i;
			n++;
		}
	}
	switch(n)
	{
		case 1:
		{
			adt8840a_fifo_inp_move1( devnum, axis[0]+1, Pulse[axis[0]], Speed[axis[0]]);                  //Uniaxial
			break;
		}
		case 2:
		{
			adt8840a_fifo_inp_move2( devnum, axis[0]+1, axis[1]+1, Pulse[axis[0]], Pulse[axis[1]], Speed[axis[0]]);                  //Uniaxial
			break;
		}
		case 3:
		{
			adt8840a_fifo_inp_move3( devnum, axis[0]+1, axis[1]+1, axis[2]+1, Pulse[axis[0]], Pulse[axis[1]], Pulse[axis[2]], Speed[axis[0]]); 
			break;
		}
		case 4:
		{
			adt8840a_fifo_inp_move4(devnum,Pulse[axis[0]],Pulse[axis[1]],Pulse[axis[2]],Pulse[axis[3]],Speed[axis[0]]);
			break;
		}
		default:
			MessageBox("Please select the linkage shaft!", "Prompt");
			break;
	} 
}

void CDEMODlg::OnBtnOpenGfile() 
{
	static char *g_code;
	int code_len,result;

	if(g_code!=0)
	{
		adt8840a_dll_free(g_code);
		g_code=0;
	}
	g_code=adt8840a_upload_gfile(devnum,&result,&code_len);
	if(result==0)
	{
		SetDlgItemText(IDC_EDIT_SHOW_GFILE,g_code);
		m_bOpenGfile=TRUE;		
	}	
}

void CDEMODlg::OnBtnHome() 
{
	UpdateData();

	adt8840a_go_home(devnum);	
}

void CDEMODlg::OnCheckBuffMode() 
{
	UpdateData();
	if(m_buff)
		adt8840a_set_buff_mode(devnum,1);
	else
		adt8840a_set_buff_mode(devnum,0);		
}

void CDEMODlg::OnFsSpeedmode0() 
{
	UpdateData();
	adt8840a_set_speed_mode(devnum,0);//Speed mode for free		
}

void CDEMODlg::OnFsSpeedmode1() 
{
	UpdateData();
	adt8840a_set_speed_mode(devnum,1);//Speed is fixed mode, fixed-rate mode, fixed mode to set the speed of the file system of priority	
}

void CDEMODlg::OnBtnArc() 
{        
	UpdateData();
	adt8840a_set_speed(devnum,1,m_nSpeedX);
	adt8840a_set_speed(devnum,2,m_nSpeedY);
	
    m_bDrawTrail=TRUE;
	int  result =adt8840a_arc( devnum, 0,1,2,2000,2000,1000,1000);//Shun Yuen
    adt8840a_arc( devnum, 1,1,2,2000,2000,1000,1000);             //Reverse round
   
}

void CDEMODlg::OnBtnSingleGcode() 
{
	//For the text box line of G code instructions, and perform
	int index,clen;
	CString GCode;
	m_bDrawTrail=TRUE;
	index = ((CEdit*)GetDlgItem(IDC_EDIT_SHOW_GFILE))->LineIndex(0);
	clen = ((CEdit*)GetDlgItem(IDC_EDIT_SHOW_GFILE))->LineLength(index);
	clen=((CEdit*)GetDlgItem(IDC_EDIT_SHOW_GFILE))->GetLine(index,GCode.GetBuffer(clen),clen);
	if(index==0 && clen<2)
	{
		KillTimer(GCODETIMER);
		AfxMessageBox("No Date");
	}else
		adt8840a_g_code(devnum,(LPSTR)(LPCSTR)GCode);
}

void CDEMODlg::OnBtnMultiGcode() 
{
//The following are non-routine circumstances, the continuous online processing model; If the G file a subroutine, it is best not to use a continuous G command

    m_nLineCount=0;
	m_bDrawTrail=TRUE;
	SetTimer(GCODETIMER,20,NULL);


}
void CDEMODlg::OnButtonFreshen() 
{//Refresh path
	GetDlgItem(IDC_RTAIL)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_RTAIL)->ShowWindow(SW_SHOW);	
}

void CDEMODlg::OnButtonRunram() 
{
	int idle,status,lock_stop;
	m_bDrawTrail=TRUE;
	adt8840a_get_sys_status( devnum,&idle,&status,&lock_stop);
	if(idle||status)
		AfxMessageBox("Is currently being processed, and can not execute this command");
	else
	{
		if(adt8840a_run_gcode(devnum)!=0)
		{
			adt8840a_get_sys_status( devnum,&idle,&status,&lock_stop);
			if(status==0)
				AfxMessageBox("The command fails, there is no instruction cache");
		}
	}
}

void CDEMODlg::OnButtonDownload() 
{
	int idle,g_status,lock_stop;
	adt8840a_get_sys_status( devnum,&idle,&g_status,&lock_stop);
	if(idle||g_status)
		AfxMessageBox("Execute the command fails, there is no instruction cache");
	else
	{
		adt8840a_buff_block_status(devnum,&m_nDataStatus);
		if(m_nDataStatus)
			AfxMessageBox("Control card instruction cache is full, can not execute this command");
		else
		{
			m_nSendLen=0;
			SetTimer(BLOCKTIMER, 30, 0);
		}
	}
}

BOOL CDEMODlg::PreTranslateMessage(MSG* pMsg) 
{//Depending on the key messages driving instructions to perform different
	if (pMsg->message==WM_LBUTTONDOWN && pMsg->hwnd==GetDlgItem(IDC_BUTTON_UP)->m_hWnd)
	{
			m_bDrawTrail=TRUE;
			adt8840a_continue_move(devnum,2,1);
			hand_mov=1;
	}
	if (pMsg->message==WM_LBUTTONUP && pMsg->hwnd==GetDlgItem(IDC_BUTTON_UP)->m_hWnd)
	{
			adt8840a_dec_stop(devnum,2);
			hand_mov=0;
			m_bDrawTrail=FALSE;
	}
	if (pMsg->message==WM_LBUTTONDOWN && pMsg->hwnd==GetDlgItem(IDC_BUTTON_DOWN)->m_hWnd)
	{
			m_bDrawTrail=TRUE;
			adt8840a_continue_move(devnum,2,0);
			hand_mov=1;
	}
	if (pMsg->message==WM_LBUTTONUP && pMsg->hwnd==GetDlgItem(IDC_BUTTON_DOWN)->m_hWnd)
	{
			adt8840a_dec_stop(devnum,2);
			hand_mov=0;
			m_bDrawTrail=FALSE;
	}
	if (pMsg->message==WM_LBUTTONDOWN && pMsg->hwnd==GetDlgItem(IDC_BUTTON_LEFT)->m_hWnd)
	{
			m_bDrawTrail=TRUE;
			adt8840a_continue_move(devnum,1,1);
			hand_mov=1;
	}
	if (pMsg->message==WM_LBUTTONUP && pMsg->hwnd==GetDlgItem(IDC_BUTTON_LEFT)->m_hWnd)
	{
			adt8840a_dec_stop(devnum,1);
			hand_mov=0;
			m_bDrawTrail=FALSE;
	}
	if (pMsg->message==WM_LBUTTONDOWN && pMsg->hwnd==GetDlgItem(IDC_BUTTON_RIGHT)->m_hWnd)
	{
			m_bDrawTrail=TRUE;
			adt8840a_continue_move(devnum,1,0);
			hand_mov=1;
	}
	if (pMsg->message==WM_LBUTTONUP && pMsg->hwnd==GetDlgItem(IDC_BUTTON_RIGHT)->m_hWnd)
	{
			adt8840a_dec_stop(devnum,1);
			hand_mov=0;
			m_bDrawTrail=FALSE;
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CDEMODlg::OnCheckPauseresum() 
{
	UpdateData();
	GetDlgItem(IDC_CHECK_PAUSERESUM)->SetWindowText(m_PAUSE?"Recovery process ":" The suspension of processing");		
	if (m_PAUSE) 
	{
		adt8840a_pause(devnum); //Suspension of processing
	}
	else
	{
		adt8840a_Resume(devnum);//Recovery process
	}	

}


void CDEMODlg::OnCloseConn() 
{
	// TODO: Add your control notification handler code here
    int  len,ID_number;
    CString show;
	char str[32];
	CButton *btn;

    GetDlgItemText(IDC_EDIT_IDNUM,show);
	len=show.GetLength()+1;
	strncpy(str, show, len-1);
	str[len-1]=0;
	ID_number=atoi(str);


	Close_netconn(ID_number);
	SetDlgItemText(IDC_EDIT_IDNUM,"256");
	SetDlgItemText(IDC_EDIT_LINKSTATUS,"Disconnected");
	SetDlgItemText(IDC_OPERATE_INFO,"Implementation of the disconnected OK");
	KillTimer(TRACETIMER); 
	KillTimer(MAINTIMER);
	KillTimer(GCODETIMER);

	btn=(CButton*)GetDlgItem(IDC_IPADDRS);
	btn->EnableWindow(TRUE);	
	btn=(CButton*)GetDlgItem(IDC_EDIT_MAC);
	btn->EnableWindow(TRUE);	
	btn=(CButton*)GetDlgItem(IDC_BTN_INTIAL_DEV);
	btn->EnableWindow(TRUE);
	btn=(CButton*)GetDlgItem(IDC_CLOSE_CONN);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_FS_SPEEDMODE0);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_FS_SPEEDMODE1);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_CHECK_UART);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_CHECK_BUFF_MODE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_UP);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_DOWN);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_LEFT);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_RIGHT);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_PMOVE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_CMOVE);		
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_INPMOVE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_CLEARPOS);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_BASEPARA);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_IOTEST);		
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_FIFO);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_ARC);
	btn->EnableWindow(FALSE);			

	btn=(CButton*)GetDlgItem(IDC_BTN_SYSPARAM);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_LOAD_GFILE);
	btn->EnableWindow(FALSE);			
	btn=(CButton*)GetDlgItem(IDC_BTN_SINGLE_GCODE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_MULTI_GCODE);
	btn->EnableWindow(FALSE);						
	btn=(CButton*)GetDlgItem(IDC_BTN_GFILE_WORK);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_HOME);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_REMOVE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_OPEN_GFILE);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_FRESHEN);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_CHECK_PAUSERESUM);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BTN_WORKSTOP);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_STOP);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_DOWNLOAD);
	btn->EnableWindow(FALSE);
	btn=(CButton*)GetDlgItem(IDC_BUTTON_RUNRAM);
	btn->EnableWindow(FALSE);
}
